<?php $__env->startSection('content'); ?>
<h5 class="mb-4 fw-light">
    <a class="text-reset" href="<?php echo e(url('panel/admin'), false); ?>"><?php echo e(__('admin.dashboard'), false); ?></a>
    <i class="bi-chevron-right me-1 fs-6"></i>
    <span class="text-muted"><?php echo e(__('general.advertising'), false); ?></span>

    <a href="<?php echo e(url('panel/admin/advertising/add'), false); ?>" class="btn btn-sm btn-dark float-lg-end mt-1 mt-lg-0">
        <i class="bi-plus-lg"></i> <?php echo e(__('general.add_new'), false); ?>

    </a>
</h5>

<div class="content">
    <div class="row">

        <div class="col-lg-12">

            <?php if(session('success_message')): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <i class="bi bi-check2 me-1"></i> <?php echo e(session('success_message'), false); ?>


                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
                    <i class="bi bi-x-lg"></i>
                </button>
            </div>
            <?php endif; ?>

            <div class="card shadow-custom border-0">
                <div class="card-body p-lg-4">

                    <div class="table-responsive p-0">
                        <table class="table table-hover">
                            <tbody>

                                <?php if($ads->count()): ?>
                                <tr>
                                    <th class="active"><?php echo e(__('admin.title'), false); ?></th>
                                    <th class="active"><?php echo e(__('general.clicks'), false); ?></th>
                                    <th class="active"><?php echo e(__('general.impressions'), false); ?></th>
                                    <th class="active"><?php echo e(__('admin.date'), false); ?></th>
                                    <th class="active"><?php echo e(__('general.expiry'), false); ?></th>
                                    <th class="active"><?php echo e(__('admin.status'), false); ?></th>
                                    <th class="active"><?php echo e(__('admin.actions'), false); ?></th>
                                </tr>

                                <?php $__currentLoopData = $ads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ad): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e(str_limit($ad->title, 30), false); ?></td>
                                    <td><?php echo e($ad->clicks, false); ?></td>
                                    <td><?php echo e($ad->impressions, false); ?></td>
                                    <td><?php echo e(Helper::formatDate($ad->created_at), false); ?></td>
                                    <td><?php echo e(Helper::formatDate($ad->expired_at), false); ?></td>
                                    <td>
                                        <span class="badge bg-<?php echo e($ad->status->label(), false); ?>">
                                            <?php echo e($ad->status->locale(), false); ?>

                                            </span>
                                        </td>
                                    <td>
                                        <a href="<?php echo e(url('panel/admin/advertising/edit', $ad->id), false); ?>"
                                            class="btn btn-success rounded-pill btn-sm me-2">
                                            <i class="bi-pencil"></i>
                                        </a>

                                        <form method="POST"
                                            action="<?php echo e(route('advertising.destroy', ['ad' => $ad->id]), false); ?>"
                                            accept-charset="UTF-8" class="d-inline-block align-top">
                                            <?php echo csrf_field(); ?>
                                            <button class="btn btn-danger rounded-pill btn-sm actionDelete"
                                                type="button"><i class="bi-trash-fill"></i>
                                            </button>
                                        </form>

                                    </td>
                                </tr><!-- /.TR -->
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                <?php else: ?>
                                <h5 class="text-center p-5 text-muted fw-light m-0"><?php echo e(__('general.no_results_found'), false); ?></h5>
                                <?php endif; ?>

                            </tbody>
                        </table>
                    </div><!-- /.box-body -->

                </div><!-- card-body -->
            </div><!-- card  -->
        </div><!-- col-lg-12 -->

    </div><!-- end row -->
</div><!-- end content -->
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/diam1987/public_html/resources/views/admin/advertising.blade.php ENDPATH**/ ?>