

<?php $__env->startSection('css'); ?>
<link href="<?php echo e(asset('public/js/plyr/plyr.css'), false); ?>?v=<?php echo e($settings->version, false); ?>" rel="stylesheet" type="text/css" />
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
	<h5 class="mb-4 fw-light">
    <a class="text-reset" href="<?php echo e(url('panel/admin'), false); ?>"><?php echo e(__('admin.dashboard'), false); ?></a>
      <i class="bi-chevron-right me-1 fs-6"></i>
	  <span class="text-muted"><?php echo e(__('general.stories'), false); ?></span>
	  <i class="bi-chevron-right me-1 fs-6"></i>
      <span class="text-muted"><?php echo e(__('general.posts'), false); ?> (<?php echo e($data->total(), false); ?>)</span>
  </h5>

<div class="content">
	<div class="row">
		<div class="col-lg-12">

			<?php if(session('success_message')): ?>
      <div class="alert alert-success alert-dismissible fade show" role="alert">
              <i class="bi bi-check2 me-1"></i>	<?php echo e(session('success_message'), false); ?>


                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
                  <i class="bi bi-x-lg"></i>
                </button>
                </div>
              <?php endif; ?>

			<div class="card shadow-custom border-0">
				<div class="card-body p-lg-4">
					<div class="table-responsive p-0">
						<table class="table table-hover">
						 <tbody>

							<?php if($data->count() !=  0): ?>
								 <tr>
									  <th class="active">ID</th>
										<th class="active"><?php echo e(trans('admin.description'), false); ?></th>
										<th class="active"><?php echo e(trans('admin.content'), false); ?></th>
										<th class="active"><?php echo e(trans('general.creator'), false); ?></th>
										<th class="active"><?php echo e(trans('admin.date'), false); ?></th>
										<th class="active"><?php echo e(trans('admin.actions'), false); ?></th>
									</tr>

								<?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $story): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

									<?php
										$media = $story->media[0];
									?>

									<tr>
										<td><?php echo e($story->id, false); ?></td>
										<td class="text-break"><?php echo e($story->title ? $story->title : ($media->text ? $media->text : __('general.not_applicable')), false); ?></td>

										<td>
											<?php if($media->type == 'photo' && ! $media->text): ?>
												<i class="far fa-image"></i>
											<?php endif; ?>

											<?php if($media->text): ?>
												<i class="fa fa-font"></i>
											<?php endif; ?>

											<?php if($media->type == 'video'): ?>
												<i class="far fa-play-circle"></i>
											<?php endif; ?>
										</td>

										<td>
											<?php if(isset($story->user->username)): ?>
												<a href="<?php echo e(url($story->user->username), false); ?>" target="_blank">
													<?php echo e($story->user->username, false); ?> <i class="fa fa-external-link-square-alt"></i>
												</a>
											<?php else: ?>
												<em><?php echo e(trans('general.no_available'), false); ?></em>
											<?php endif; ?>

											</td>
										<td><?php echo e(Helper::formatDate($story->created_at), false); ?></td>
										<td>
											<div class="d-flex">
											<?php if(! $media->text): ?>
											<a href="<?php echo e(Helper::getFile(config('path.stories').$media->name), false); ?>" class="btn btn-success btn-sm rounded-pill me-2 glightbox" data-gallery="gallery<?php echo e($media->id, false); ?>">
												<i class="bi-eye"></i>
											</a>
											<?php endif; ?>

										 <?php echo Form::open([
											 'method' => 'POST',
											 'url' => "panel/admin/stories/posts/delete/$story->id",
											 'class' => 'displayInline'
										 ]); ?>

										 
										 <?php echo Form::button('<i class="bi-trash-fill"></i>', ['class' => 'btn btn-danger btn-sm padding-btn rounded-pill actionDelete']); ?>


										 <?php echo Form::close(); ?>


									 </div>
									</td>

									</tr><!-- /.TR -->
									<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

									<?php else: ?>
										<h5 class="text-center p-5 text-muted fw-light m-0"><?php echo e(trans('general.no_results_found'), false); ?></h5>
									<?php endif; ?>

								</tbody>
								</table>
							</div><!-- /.box-body -->

				 </div><!-- card-body -->
 			</div><!-- card  -->

		<?php if($data->lastPage() > 1): ?>
			<?php echo e($data->onEachSide(0)->links(), false); ?>

		<?php endif; ?>
 		</div><!-- col-lg-12 -->

	</div><!-- end row -->
</div><!-- end content -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
<script src="<?php echo e(asset('public/js/plyr/plyr.min.js'), false); ?>?v=<?php echo e($settings->version, false); ?>"></script>
<script src="<?php echo e(asset('public/js/plyr/plyr.polyfilled.min.js'), false); ?>?v=<?php echo e($settings->version, false); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/diam1987/public_html/resources/views/admin/stories-posts.blade.php ENDPATH**/ ?>