<?php $__env->startSection('title'); ?> <?php echo e(__('auth.password_recover'), false); ?> -<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>
  <script type="text/javascript">
      var error_scrollelement = <?php echo e(count($errors) > 0 ? 'true' : 'false', false); ?>;
  </script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
  <div class="jumbotron home m-0 bg-gradient">
    <div class="container pt-lg-md">
      <div class="row justify-content-center">
        <div class="col-lg-5">
          <div class="card bg-white shadow border-0 b-radio-custom">

              <h4 class="text-center mb-0 font-weight-bold pt-4 px-4">
                <?php echo e(__('auth.password_recover'), false); ?>

              </h4>
              <small class="btn-block text-center mt-2 px-4"><?php echo e(__('auth.recover_pass_subtitle'), false); ?></small>

            <div class="card-body px-lg-5 py-lg-5">
              <?php if(session('status')): ?>
                      <div class="alert alert-success">
                        <?php echo e(session('status')); ?>

                      </div>
                    <?php endif; ?>

              <?php echo $__env->make('errors.errors-forms', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

              <form method="POST" action="<?php echo e(route('password.email'), false); ?>" id="passwordEmailForm">
                  <?php echo csrf_field(); ?>
                <div class="form-group mb-3">
                  <div class="input-group input-group-alternative">
                    <div class="input-group-prepend">
                      <span class="input-group-text"><i class="feather icon-mail"></i></span>
                    </div>
                    <input class="form-control <?php if(count($errors) > 0): ?> is-invalid <?php endif; ?>" value="<?php echo e(old('email'), false); ?>" placeholder="<?php echo e(__('auth.email'), false); ?>" name="email" required type="text">

                  </div>
                </div>

                <div class="text-center">
                  <?php if($settings->captcha == 'on'): ?>
                  <?php echo NoCaptcha::displaySubmit('passwordEmailForm', __('auth.send_pass_reset'), ['data-size' => 'invisible', 'class' => 'btn btn-primary my-4 w-100']); ?>


                  <?php echo NoCaptcha::renderJs(); ?>

                  <?php else: ?>
                  <button type="submit" class="btn btn-primary my-4 w-100"><?php echo e(__('auth.send_pass_reset'), false); ?></button>
                  <?php endif; ?>
                </div>
              </form>

              <?php if($settings->captcha == 'on'): ?>
                <small class="btn-block text-center"><?php echo e(__('auth.protected_recaptcha'), false); ?> <a href="https://policies.google.com/privacy" target="_blank"><?php echo e(__('general.privacy'), false); ?></a> - <a href="https://policies.google.com/terms" target="_blank"><?php echo e(__('general.terms'), false); ?></a></small>
              <?php endif; ?>

            </div>
          </div>
          <div class="row mt-3">
            <div class="col-6">
              <a href="<?php echo e(url()->previous(), false); ?>" class="text-light">
                <small><i class="fas fa-arrow-left"></i> <?php echo e(__('general.go_back'), false); ?></small>
              </a>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/diam1987/public_html/resources/views/auth/passwords/email.blade.php ENDPATH**/ ?>