<?php $__env->startSection('title'); ?> <?php echo e(__('general.conversations'), false); ?> -<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>
<style type="text/css">
  .fileuploader { display:block; padding: 0; }
  .fileuploader-items-list {margin: 10px 0 0 0;}
  .fileuploader-theme-dragdrop .fileuploader-input {
    background: <?php echo e(auth()->user()->dark_mode == 'on'? '#222' : '#fff', false); ?>;  
  }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<section class="section section-sm">
    <div class="container">
      <div class="row justify-content-center text-center mb-sm">
        <div class="col-lg-8 py-5">
          <h2 class="mb-0 font-montserrat"><i class="feather icon-send mr-2"></i> <?php echo e(__('general.conversations'), false); ?></h2>
          <p class="lead text-muted mt-0"><?php echo e(__('general.subtitle_conversations'), false); ?></p>
        </div>
      </div>
      <div class="row">

        <?php echo $__env->make('includes.cards-settings', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <div class="col-md-6 col-lg-9 mb-5 mb-lg-0">

          <?php if(session('status')): ?>
                  <div class="alert alert-success">
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                
                    <i class="bi-check2 mr-2"></i> <?php echo e(session('status'), false); ?>

                </div>
                <?php endif; ?>

          <?php echo $__env->make('errors.errors-forms', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

          <form method="POST" action="<?php echo e(route('settings.conversations_update'), false); ?>">
            <?php echo csrf_field(); ?>
              <div class="form-group">
                <div class="btn-block mb-4">
                    <div class="custom-control custom-switch custom-switch-lg">
                      <input type="checkbox" class="custom-control-input" name="allow_dm" value="1" <?php if(auth()->user()->allow_dm): echo 'checked'; endif; ?> id="allow_dm">
                      <label class="custom-control-label switch" for="allow_dm"><?php echo e(__('general.receive_private_messages'), false); ?></label>
                    </div>
                  </div>

                  <div class="btn-block mb-4">
                    <div class="custom-control custom-switch custom-switch-lg">
                      <input type="checkbox" class="custom-control-input" name="send_welcome_message" value="1" <?php if(auth()->user()->send_welcome_message): echo 'checked'; endif; ?> id="send_welcome_message">
                      <label class="custom-control-label switch" for="send_welcome_message"><?php echo e(__('general.send_welcome_message_new_subscribers'), false); ?></label>
                    </div>
                  </div>
                </div>

                <div class="form-group mb-4">
                  <label class="w-100 "><?php echo e(__('general.price_welcome_message'), false); ?> (<?php echo e(__('general.optional'), false); ?>)</label>
                  <div class="input-group mb-2">
                    <div class="input-group-prepend">
                      <span class="input-group-text"><?php echo e($settings->currency_symbol, false); ?></span>
                    </div>
                        <input value="<?php echo e(auth()->user()->price_welcome_message, false); ?>" class="form-control form-control-lg isNumber" name="price_welcome_message" autocomplete="off" placeholder="0.00" type="text">
                    </div>
                    <small class="btn-block">
                      * <?php echo e(__('general.minimum'), false); ?> <?php echo e(Helper::priceWithoutFormat(config('settings.min_ppv_amount')), false); ?> - <?php echo e(__('general.maximum'), false); ?> <?php echo e(Helper::priceWithoutFormat(config('settings.max_ppv_amount')), false); ?>


                    <?php if($settings->wallet_format != 'real_money'): ?>
											<strong>(<?php echo e(Helper::equivalentMoney($settings->wallet_format), false); ?>)</strong>
										<?php endif; ?>
                    </small>
                </div>

                <div class="form-group">
                  <label class="w-100 "><?php echo e(__('general.add_file'), false); ?> (<?php echo e(__('general.optional'), false); ?>)</label>

                  <?php if($settings->video_encoding == 'on'): ?>
                  <div class="alert alert-primary m-0 alert-dismissible fade show" role="alert">
                    <i class="fa fa-info-circle mr-2"></i>
                    <?php echo e(__('general.info_video_encode_welcome_msg'), false); ?>

                  </div>
                  <?php endif; ?>
                  
                <input <?php if($preloadedFile): ?> data-fileuploader-files='<?php echo $preloadedFile; ?>' <?php endif; ?> type="file" name="media" accept="image/*,video/mp4,video/x-m4v,video/quicktime,audio/mp3">
              </div>

               <div class="form-group">
                    <label class="w-100"><?php echo e(__('general.welcome_message_new_subs'), false); ?></label>
                    <textarea name="message" rows="5" cols="40" class="form-control textareaAutoSize"><?php echo e(auth()->user()->welcome_message_new_subs ? auth()->user()->welcome_message_new_subs : old('welcome_message_new_subs'), false); ?></textarea>
                </div>

                <button class="btn btn-1 btn-success btn-block buttonActionSubmit" type="submit"><?php echo e(__('general.save_changes'), false); ?></button>

          </form>
        </div><!-- end col-md-6 -->
      </div>
    </div>
  </section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
  <script src="<?php echo e(asset('public/js/fileuploader/fileuploader-welcome-msg.js'), false); ?>"></script>

  <?php if(session('encode')): ?>
 <script type="text/javascript">
    swal({
      type: 'info',
      title: video_on_way,
      text: video_processed_info,
      confirmButtonText: ok
      });
    </script>
   <?php endif; ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/diam1987/public_html/resources/views/users/conversations.blade.php ENDPATH**/ ?>