

<?php $__env->startSection('title'); ?> <?php echo e(__('general.story_text'), false); ?> -<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<section class="section section-sm">
    <div class="container">
      <div class="row justify-content-center text-center mb-sm">
        <div class="col-lg-12 py-5">
          <h2 class="mb-0 font-montserrat">
            <?php echo e(__('general.story_text'), false); ?>

          </h2>
          <p class="lead text-muted mt-0">
            <?php echo e(__('general.add_story_text_subtitle'), false); ?>

        </p>
        </div>
      </div>
      <div class="row">

        <div class="col-lg-5 second">
          <form action="<?php echo e(url()->current(), false); ?>" method="post" enctype="multipart/form-data" id="addStoryForm">
            <?php echo csrf_field(); ?>
            <input class="inputBackground" type="hidden" name="background" value="<?php echo e($storyBackgrounds[0]['name'], false); ?>">
            <input class="inputColor" type="hidden" name="color" value="#ffffff">
            
            <div class="form-group position-relative">

              <div>
                <span class="triggerEmoji" style="top: 10px; right: 8px;" data-toggle="dropdown">
                  <i class="bi-emoji-smile"></i>
                </span>

                <div class="dropdown-menu dropdown-menu-right dropdown-emoji custom-scrollbar" aria-labelledby="dropdownMenuButton">
                  <?php echo $__env->make('includes.emojis', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
              </div>

              <textarea class="form-control textareaAutoSize emojiArea addTextStory" style="padding-right: 30px;" maxlength="300" name="text" placeholder="<?php echo e(__('general.start_typing'), false); ?>" rows="4"></textarea>
            </div>

            <?php if($storyFonts->count()): ?>
            <div class="form-group">
              <div class="input-group mb-4">
              <div class="input-group-prepend">
                <span class="input-group-text"><i class="bi-type"></i></span>
              </div>
              <select name="font" class="form-control custom-select" id="storyFont">
                <option selected="selected" value="Arial">Arial</option>
                <?php $__currentLoopData = $storyFonts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $font): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <option value="<?php echo e($font->name, false); ?>"><?php echo e($font->name, false); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                </div>
              </div><!-- ./form-group -->
              <?php endif; ?>

            <h6><?php echo e(__('general.backgrounds'), false); ?></h6>

            <div class="my-3 container-backgrounds d-block">
              <?php $__currentLoopData = $storyBackgrounds; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $background): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <img src="<?php echo e(url('public/img/stories-bg', $background->name), false); ?>" data-bg-name="<?php echo e($background->name, false); ?>" data-bg="<?php echo e(url('public/img/stories-bg', $background->name), false); ?>" class="mr-1 mb-2 storyBackgrounds storyBg">
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

            <h6><?php echo e(__('general.font_color'), false); ?></h6>

            <div class="my-3 container-backgrounds d-block">
              <span class="fontColor fontColor-white active border mr-1" data-color="#ffffff"></span>
              <span class="fontColor fontColor-black" data-color="#000000"></span>
            </div>

            <!-- Alert -->
          <div class="alert alert-danger my-3 display-none" id="errorCreateStory">
             <ul class="list-unstyled m-0" id="showErrorsCreateStory"><li></li></ul>
           </div><!-- Alert -->

            <button class="btn btn-1 btn-primary btn-block" id="createStoryBtn" type="submit"><i></i> <?php echo e(__('users.create'), false); ?></button>
          </form>
        </div>

        <div class="col-lg-7 first">
          <div class="d-block w-100">
            <div class="bg-current w-100 bg-black mb-3 d-block py-4 px-lg-0 px-4">
              <div class="bg-inside text-center mx-auto" style="background: #6a6a6a url('<?php echo e(url('public/img/stories-bg', $storyBackgrounds[0]['name']), false); ?>') no-repeat center center; background-size: cover;">
                <div class="flex-column d-flex justify-content-center text-center h-100 text-story px-4">
                  <?php echo e(__('general.start_typing'), false); ?>

                </div>
              </div>
            </div>
          </div>
        </div><!-- end col-md-12 -->
      </div>
    </div>
  </section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?> 
  <script src="<?php echo e(asset('public/js/story/create-story.js'), false); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/diam1987/public_html/resources/views/users/create-story-text.blade.php ENDPATH**/ ?>