<?php $__env->startSection('content'); ?>
<h5 class="mb-4 fw-light">
  <a class="text-reset" href="<?php echo e(url('panel/admin'), false); ?>"><?php echo e(__('admin.dashboard'), false); ?></a>
  <i class="bi-chevron-right me-1 fs-6"></i>
  <a class="text-reset" href="<?php echo e(url('panel/admin/advertising'), false); ?>"><?php echo e(__('general.advertising'), false); ?></a>
  <i class="bi-chevron-right me-1 fs-6"></i>
  <span class="text-muted"><?php echo e(__('admin.edit'), false); ?></span>
</h5>

<div class="content">
  <div class="row">

    <div class="col-lg-12">

      <?php echo $__env->make('errors.errors-forms', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

      <div class="card shadow-custom border-0">
        <div class="card-body p-lg-5">

          <form method="post" action="<?php echo e(route('advertising.update', ['id' => $ad->id]), false); ?>"
            enctype="multipart/form-data">
            <?php echo csrf_field(); ?>

            <div class="row mb-3">
              <label class="col-sm-2 col-form-label text-lg-end"><?php echo e(__('admin.title'), false); ?></label>
              <div class="col-sm-10">
                <input value="<?php echo e($ad->title, false); ?>" name="title" required type="text" class="form-control">
              </div>
            </div>

            <div class="row mb-3">
              <label class="col-sm-2 col-form-label text-lg-end"><?php echo e(__('admin.description'), false); ?></label>
              <div class="col-sm-10">
                <input value="<?php echo e($ad->description, false); ?>" name="description" required type="text" class="form-control">
              </div>
            </div>

            <div class="row mb-3">
              <label class="col-sm-2 col-form-label text-lg-end"><?php echo e(__('general.url_ad'), false); ?></label>
              <div class="col-sm-10">
                <input value="<?php echo e($ad->url, false); ?>" name="url" required type="text" class="form-control">
              </div>
            </div>

            <div class="row mb-3">
              <label class="col-sm-2 col-form-labe text-lg-end"><?php echo e(__('general.expiry'), false); ?></label>
              <div class="col-sm-10">
                <select name="expired_at" class="form-select">
                  <?php for($i = 1; $i <= 12; ++$i): ?> <option value="<?php echo e($i, false); ?>">
                    <?php echo e($i, false); ?> <?php echo e(trans_choice('general.months', $i), false); ?>

                    </option>
                    <?php endfor; ?>
                </select>

                <div class="text-muted D-block mt-1">
                  <div class="form-check form-switch form-switch-sm">
                    <input type="checkbox" class="form-check-input" name="updateExpirationDate" value="1"
                      id="customSwitch1">
                    <label class="custom-control-label switch" for="customSwitch1"><?php echo e(__('general.update_expiration_date'), false); ?></label>
                  </div>
                </div>
              </div>
            </div>

            <div class="row mb-3">
              <label class="col-sm-2 col-form-label text-lg-end"><?php echo e(__('general.image'), false); ?></label>
              <div class="col-lg-5 col-sm-10">
                <div class="input-group mb-1">
                  <input name="image" type="file" class="form-control custom-file rounded-pill">
                </div>
                <small class="d-block">(JPG, PNG) 400x400</small>
              </div>
            </div>

            <fieldset class="row mb-3">
              <legend class="col-form-label col-sm-2 pt-0 text-lg-end"><?php echo e(__('admin.status'), false); ?></legend>
              <div class="col-sm-10">
                <div class="form-check form-switch form-switch-md">
                  <input class="form-check-input" type="checkbox" <?php if($ad->status->value === 2): echo 'disabled'; endif; ?> name="status" <?php if($ad->status->value): echo 'checked'; endif; ?> value="1"
                  role="switch">
                </div>
              </div>
            </fieldset><!-- end row -->

            <div class="row mb-3">
              <div class="col-sm-10 offset-sm-2">
                <button type="submit" class="btn btn-dark mt-3 px-5"><?php echo e(__('admin.save'), false); ?></button>
              </div>
            </div>

          </form>

        </div><!-- card-body -->
      </div><!-- card  -->
    </div><!-- col-lg-12 -->

  </div><!-- end row -->
</div><!-- end content -->
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/diam1987/public_html/resources/views/admin/edit-advertising.blade.php ENDPATH**/ ?>