<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\File;
use Illuminate\Support\Facades\Storage;
use App\Models\User;
use App\Models\Updates;
use App\Models\Messages;
use App\Models\AdminSettings;
use App\Models\Media;
use Carbon\Carbon;
use App\Helper;
use Image;
use FileUploader;

class UploadMediaPreviewShopController extends Controller
{

	public function __construct(AdminSettings $settings, Request $request)
	{
		$this->settings = $settings::first();
		$this->request = $request;
    	$this->middleware('auth');
	}

	/**
     * submit the form
     *
     * @return void
     */
	public function store()
	{
		$publicPath = public_path('temp/');
		$file = strtolower(auth()->id().uniqid().time().str_random(20));

		// initialize FileUploader
		$FileUploader = new FileUploader('preview', array(
			'limit' => 5,
			'fileMaxSize' => floor($this->settings->file_size_allowed / 1024),
			'extensions' => [
				'png',
	      'jpeg',
	      'jpg'
	    ],
			'title' => $file,
			'uploadDir' => $publicPath
		));

		// upload
		$upload = $FileUploader->upload();

		if ($upload['isSuccess']) {

			foreach($upload['files'] as $key=>$item) {
				$upload['files'][$key] = [
					'extension' => $item['extension'],
					'format' => $item['format'],
					'name' => $item['name'],
					'size' => $item['size'],
					'size2' => $item['size2'],
					'type' => $item['type'],
					'uploaded' => true,
					'replaced' => false
				];

				$this->resizeImage($item['name'], $item['extension']);

			}// foreach

		}// upload isSuccess

		return response()->json($upload);
	}

	/**
     * Resize image and add watermark
     *
     * @return void
     */
		 protected function resizeImage($image, $extension)
		 {
			 $fileName = $image;
			 $image = public_path('temp/').$image;
			 $img   = Image::make($image);
			 $token = str_random(150).uniqid().now()->timestamp;
			 $url   = ucfirst(Helper::urlToDomain(url('/')));

			 $width     = $img->width();
			 $height    = $img->height();

				 //=============== Image Large =================//
				 if ($width > 2000) {
					 $scale = 2000;
				 } else {
					 $scale = $width;
				 }

				 // Calculate font size
				 if ($width >= 400 && $width < 900) {
					 $fontSize = 18;
				 } elseif ($width >= 800 && $width < 1200) {
					 $fontSize = 24;
				 } elseif ($width >= 1200 && $width < 2000) {
					 $fontSize = 32;
				 } elseif ($width >= 2000 && $width < 3000) {
					 $fontSize = 50;
				 } elseif ($width >= 3000) {
					 $fontSize = 75;
				 } else {
					 $fontSize = 0;
				 }

				 if ($this->settings->watermark == 'on') {
					 $img->orientate()->resize($scale, null, function ($constraint) {
						 $constraint->aspectRatio();
						 $constraint->upsize();
					 })->text($url.'/'.auth()->user()->username, $img->width() - 20, $img->height() - 10, function($font)
							 use ($fontSize) {
							 $font->file(public_path('webfonts/arial.TTF'));
							 $font->size($fontSize);
							 $font->color('#eaeaea');
							 $font->align('right');
							 $font->valign('bottom');
					 })->save();
				 } else {
					 $img->orientate()->resize($scale, null, function ($constraint) {
						 $constraint->aspectRatio();
						 $constraint->upsize();
					 })->save();
				 }

	 }// End method resizeImage

	/**
     * delete a file
     *
     * @return void
     */
	public function delete()
	{
		// PATH
		$local = 'temp/';

		// Delete local file
		Storage::disk('default')->delete($local.$this->request->file);

    return response()->json([
        'success' => true
    ]);
	}// End method

}
